package com.wissamfawaz;

public interface DList<T> {
    public int size();

    public boolean isEmpty();

    public DNode<T> first() throws EmptyListException;

    public DNode<T> last() throws EmptyListException;

    public DNode<T> next(DNode<T> d) throws BoundaryViolationException, InvalidPositionException;

    public DNode<T> prev(DNode<T> d) throws BoundaryViolationException, InvalidPositionException;

    public T remove(DNode<T> d) throws InvalidPositionException;

    public T replace(DNode<T> d, T e) throws InvalidPositionException;

    public DNode<T> insertFirst(T e);

    public DNode<T> insertLast(T e);

    public DNode<T> insertBefore(DNode<T> d, T e) throws InvalidPositionException;

    public DNode<T> insertAfter(DNode<T> d, T e) throws InvalidPositionException;

}
